<?php
defined( 'ABSPATH' ) or die();

add_filter('rsssl_integrations_path', 'rsssl_pro_integrations_path', 10, 2);
function rsssl_pro_integrations_path($path, $plugin)
{
    $pro_plugins = [
        'disable-http-methods',
        'xmlrpc',
        'debug-log',
        'rename-db-prefix',
        'application-passwords',
        'change-login-url',
        'vulnerabilities-pro',
        'two-factor',
        'class-rsssl-event-log',
	    'class-rsssl-event-listener',
	    'class-rsssl-limit-login-attempts',
        'block-admin-creation',
		'class-rsssl-password-security'
    ];
    if (in_array($plugin, $pro_plugins)) {
        return rsssl_pro_path;
    }
    return $path;
}
function rsssl_pro_integrations($integrations)
{
    $integrations += [
	    'disable-http-methods'  => array(
		    'label'     => __( 'Disable HTTP methods', 'really-simple-ssl' ),
		    'folder'    => 'wordpress',
		    'impact'    => 'low',
		    'risk'      => 'medium',
		    'option_id' => 'disable_http_methods',
	    ),
	    'xmlrpc'                => array(
		    'label'          => 'XMLRPC',
		    'folder'         => 'wordpress',
		    'impact'         => 'medium',
		    'risk'           => 'low',
		    'always_include' => true,
	    ),
	    'debug-log'             => array(
		    'label'            => __( 'Move debug.log', 'really-simple-ssl' ),
		    'folder'           => 'wordpress',
		    'impact'           => 'medium',
		    'risk'             => 'medium',
		    'option_id'        => 'change_debug_log_location',
		    'always_include'   => false,
		    'has_deactivation' => true,
	    ),
	    'rename-db-prefix'      => array(
		    'label'         => __( 'Rename DB prefix', 'really-simple-ssl' ),
		    'folder'        => 'wordpress',
		    'impact'        => 'high',
		    'risk'          => 'high',
		    'learning_mode' => false,
		    'option_id'     => 'rename_db_prefix',
	    ),
	    'application-passwords' => array(
		    'label'            => __( 'Disable Application passwords', 'really-simple-ssl' ),
		    'folder'           => 'wordpress',
		    'impact'           => 'low',
		    'risk'             => 'high',
		    'learning_mode'    => false,
		    'option_id'        => 'disable_application_passwords',
		    'always_include'   => false,
		    'has_deactivation' => true,
	    ),
	    'change-login-url'      => array(
		    'label'          => __( 'Change login URL', 'really-simple-ssl' ),
		    'folder'         => 'wordpress',
		    'impact'         => 'high',
		    'risk'           => 'medium',
		    'option_id'      => 'change_login_url',
		    'always_include' => false,
	    ),
	    'vulnerabilities-pro'   => array(
		    'label'          => 'Vulnerabilities',
		    'folder'         => 'wordpress',
		    'impact'         => 'medium',
		    'risk'           => 'medium',
		    'option_id'      => 'enable_vulnerability_scanner',
		    'always_include' => false,
		    'admin_only'     => true,
	    ),
        'class-rsssl-event-log'  => array(
            'label'          => 'Event Log',
            'folder'         => 'wordpress',
            'impact'         => 'medium',
            'risk'           => 'medium',
            'option_id'      => 'enable_limited_login_attempts',
            'always_include' => false,
            'admin_only'     => false,
        ),
	    'class-rsssl-event-listener'  => array(
		    'label'          => 'Event Listener',
		    'folder'         => 'wordpress',
		    'impact'         => 'medium',
		    'risk'           => 'medium',
		    'option_id'      => 'enable_limited_login_attempts',
		    'always_include' => false,
		    'admin_only'     => false,
			    ),
	    'two-factor' => array(
		    'label'                => '2FA',
		    'folder'               => 'wordpress/two_fa',
		    'impact'               => 'medium',
		    'risk'                 => 'low',
		    'option_id'            => 'two_fa_enabled',
		    'always_include'       => false,
	    ),
	    'class-rsssl-password-security'  => array(
		    'label'          => 'Password Security',
		    'folder'         => 'wordpress',
		    'impact'         => 'medium',
		    'risk'           => 'medium',
		    'option_id'      => 'enforce_password_security_enabled',
		    'always_include' => false,
		    'admin_only'     => false,
	    ),
	    'two-factor' => array(
		    'label'                => '2FA',
		    'folder'               => 'wordpress/two_fa',
		    'impact'               => 'medium',
		    'risk'                 => 'low',
		    'option_id'            => 'two_fa_enabled',
		    'always_include'       => false,
	    ),
	    'block-admin-creation'   => array(
		    'label'          => 'Vulnerabilities',
		    'folder'         => 'wordpress',
		    'option_id'      => 'block_admin_creation',
		    'always_include' => false,
		    'admin_only'     => false,
	    )
    ];
    return $integrations;
}

add_filter('rsssl_integrations', 'rsssl_pro_integrations');

/**
 * Load only on back-end
 */
$path = rsssl_pro_path . 'security/';
if ( rsssl_admin_logged_in()  ) {
	require_once( $path . 'tests.php' );
	require_once( $path . 'notices.php' );
}
